// Copyleft 2006 Chris Korda
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or any later version.
/*
        chris korda

		revision history:
		rev		date	comments
        00      03feb06	initial version

        Video Compression dialog

*/

#if !defined(AFX_VIDEOCOMPRDLG_H__DE80C91B_DF37_45B4_9942_C3C0B37CBC9A__INCLUDED_)
#define AFX_VIDEOCOMPRDLG_H__DE80C91B_DF37_45B4_9942_C3C0B37CBC9A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// VideoComprDlg.h : header file
//

#include <afxtempl.h>
#include "DirShowU.h"

/////////////////////////////////////////////////////////////////////////////
// CVideoComprDlg dialog

class CVideoComprDlg : public CDialog
{
	DECLARE_DYNCREATE(CVideoComprDlg)

// Construction
public:
	CVideoComprDlg(CWnd* pParent = NULL);
	~CVideoComprDlg();

// Attributes
	bool	SetFilters(IBaseFilter *pSource, IBaseFilter *pDest);
	IBaseFilter *GetCompr() const;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVideoComprDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
// Dialog Data
	//{{AFX_DATA(CVideoComprDlg)
	enum { IDD = IDD_VIDEO_COMPR };
	CStatic	m_QualNum;
	CSliderCtrl	m_Quality;
	CComboBox	m_Combo;
	int		m_KeyFrameEdit;
	int		m_PFramesEdit;
	int		m_DataRateEdit;
	int		m_WndSizeEdit;
	//}}AFX_DATA

// Generated message map functions
	//{{AFX_MSG(CVideoComprDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnAbout();
	afx_msg void OnConfig();
	afx_msg void OnSelchangeCombo();
	afx_msg void OnDestroy();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKillfocusKeyFrameEdit();
	afx_msg void OnKillfocusPFramesEdit();
	virtual void OnOK();
	afx_msg void OnKillfocusDataRateEdit();
	afx_msg void OnKillfocusWndSizeEdit();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Types
	typedef struct tagINFO {	// information about each compressor
		IMoniker	*pMoniker;	// unique identifier from enumeration
		IBaseFilter	*pCompr;	// compressor's base filter interface
		IAMVfwCompressDialogs	*pVfwDlg;	// Vfw compression dialogs interface
		IAMVideoCompression		*pVidCom;	// compression control interface
		void	*pDlgState;		// Vfw Configure dialog state, or NULL if none
		int		szDlgState;		// size of Vfw Configure dialog state
		double	Quality;		// compression quality, from 0..1
		long	DataRate;		// desired data rate, in bits per second
		long	KeyFrameRate;	// generate a key frame every N frames
		long	PFramesPerKey;	// number of P frames between key frames
		long	WindowSize;		// number of frames to average data rate over
		long	Caps;			// compressor's capability bits
		bool	CanConfig;		// if true, supports Vfw Configure dialog
		bool	CanAbout;		// if true, supports Vfw About dialog
		bool	CanQuality;		// if true, supports quality methods
		bool	CanCrunch;		// if true, supports compressing to a data rate
		bool	CanKeyFrame;	// if true, supports key frame rate methods
		bool	CanBFrame;		// if true, supports P frames per key methods
		bool	CanWindow;		// if true, supports window size methods
		bool	CanConnect;		// if true, compressor can be connected
	} INFO;
	
// Member data
	IFilterGraph	*m_pGraph;	// reference to user's filter graph
	IBaseFilter		*m_pSource;	// user's source filter; don't release
	IBaseFilter		*m_pDest;	// user's destination filter; don't release
	IPin	*m_pSourceOut;		// source output pin
	IPin	*m_pComprIn;		// compressor input pin
	IPin	*m_pComprOut;		// compressor output pin
	IPin	*m_pDestIn;			// destination input pin
	CStringArray	m_Name;		// array of user-friendly compressor names
	CArray<INFO, INFO&> m_Info;	// array of information about each compressor
	HRESULT	m_hr;				// most recent COM result
	int		m_SelCom;			// index of currently selected compressor
	bool	m_IsCoInit;			// true if we've initialized COM

// Helpers
	bool	EnumDevs();
	bool	ConnectCompr();
	void	DisconnectCompr();
	bool	SelectCompr();
	void	UpdateQuality();
	void	UpdateUI();
	INFO	*GetCurInfo();
};

inline CVideoComprDlg::INFO	*CVideoComprDlg::GetCurInfo()
{
	return(&m_Info[m_SelCom]);
}

inline IBaseFilter *CVideoComprDlg::GetCompr() const
{
	return(m_Info[m_SelCom].pCompr);
}

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VIDEOCOMPRDLG_H__DE80C91B_DF37_45B4_9942_C3C0B37CBC9A__INCLUDED_)
