// Copyleft 2006 Chris Korda
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or any later version.
/*
        chris korda

		revision history:
		rev		date	comments
        00      03feb06	initial version

        BMP to AVI demo

*/

// BmpToAviTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Resource.h"
#include "BmpToAvi.h"
#include "BmpToAviTest.h"
#include "VideoComprDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

void DrawFrame(CDC& dc, const BMPTOAVI_PARMS& Parms, int Frame)
{
	CSize	sz(Parms.Width, Parms.Height);
	CRect	fr(0, 0, sz.cx, sz.cy);
	FillRect(dc, fr, (HBRUSH)GetStockObject(BLACK_BRUSH));	// erase frame
	// draw horizontally moving grid
	static const int	GRID_SIZE = 6;	// smaller = harder to compress
	int	GridOrg = Frame % GRID_SIZE;
	CPen	pen(PS_SOLID, 1, RGB(0, 0, 255));	// blue
	SelectObject(dc, pen);
	for (int x = GridOrg; x < sz.cx; x += GRID_SIZE) {
		dc.MoveTo(x, 0);
		dc.LineTo(x, sz.cy);
	}
	for (int y = 0; y < sz.cy; y += GRID_SIZE) {
		dc.MoveTo(0, y);
		dc.LineTo(sz.cx, y);
	}
	// draw diagonally moving rectangle
	CPoint	p(Frame % sz.cx, Frame % sz.cy);
	CRect	rr(p.x, p.y, p.x + sz.cx / 10, p.y + sz.cy / 10);
	CBrush	br(RGB(255, 255, 0));	// yellow
	FillRect(dc, rr, br);
}

HBITMAP CreateFrame(CDC& dc, const BMPTOAVI_PARMS& Parms)
{
	HBITMAP hDib = NULL;
	if (dc.CreateCompatibleDC(NULL)) {
		BITMAPINFO	bi;
		ZeroMemory(&bi, sizeof(bi));
		bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bi.bmiHeader.biWidth = Parms.Width;
		bi.bmiHeader.biHeight = Parms.Height;
		bi.bmiHeader.biPlanes = 1;
		bi.bmiHeader.biBitCount = Parms.BitCount;
		hDib = CreateDIBSection(NULL, &bi, DIB_RGB_COLORS, NULL, NULL, 0);
	}
	return(hDib);
}

void Test(const BMPTOAVI_PARMS& Parms, int Frames, LPCSTR Path)
{
	CDC	dc;
	HBITMAP	hDib = CreateFrame(dc, Parms);	// create frame bitmap
	if (hDib == NULL) {
		printf("can't create frame\n");
		return;
	}
	HGDIOBJ	hPrevObj = dc.SelectObject(hDib);	// select bitmap into DC
	CBmpToAvi	bta;
	if (bta.Open(Parms, Path, TRUE)) {	// show video compression dialog
		for (int i = 0; i < Frames; i++) {
			DrawFrame(dc, Parms, i);
			printf("frame %d\r", i);
			bool	retc = bta.AddFrame(hDib);
			if (!retc) {
				printf("can't add frame\n");
				break;
			}
		}
	}
	if (bta.GetLastError()) {
		CString	Err, DSErr;
		bta.GetLastErrorString(Err, DSErr);
	 	printf("%s\n%s\n", Err, DSErr);
	}
	dc.SelectObject(hPrevObj);	// deselect bitmap 
	DeleteObject(hDib);	// delete bitmap
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0)) {
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	} else {
		BMPTOAVI_PARMS	Parms;
		Parms.Width = 640;
		Parms.Height = 480;
		Parms.BitCount = 16;
		Parms.FrameRate = 25;
		Test(Parms, 30, "test.avi");
	}
	return nRetCode;
}
